program WstrzykiwanieMetod;

type

  IKorektor = interface
    function KorektaPisowni(aTekst: string): string;
  end;

  TEdytorTekstu = class
  private
    FTekst: string;
    FKorektor: IKorektor;
  public
    constructor Create(aTekst: string);
    procedure EdytujTekst;
    property Korektor: IKorektor read FKorektor write FKorektor;
  end;

constructor TEdytorTekstu.Create(aTekst: string);
begin
  inherited Create;
  FTekst := aTekst;
  FKorektor := nil;
end;

procedure TEdytorTekstu.EdytujTekst;
begin
  if Korektor <> nil then
  begin
    FTekst := Korektor.KorektaPisowni(FTekst);
  end;
  // Czy coś trzeba zrobić z tekstem?
end;

begin
end.